//Experiment - 7
//Designing of chebychev/inverse chebyshev/elliptical filter from a given transfer function.

clc;
clear all;

cheblpf = iir(2,'lp','cheb1',[0.3 0],[0.1 0]);
[hzm,fr]=frmag(cheblpf,256);
figure;
plot2d(fr',hzm')
title('Chebysheve Lowpass Filter')



[cells,fact,zzeros,zpoles]=eqiir('lp','ellip',[%pi*3/8,%pi*3.5/8],0.1,0.01);
h=fact*poly(zzeros,'z')/poly(zpoles,'z');
[hzm,fr]=frmag(h,256);
figure;
plot2d(fr',hzm')
title('Elliptical Lowpass Filter')



[valcoeff, filtamp, filtfreq] = wfir ('lp', 20, [.2 0], 'hm', [0 0]);
figure;
plot2d(filtfreq,filtamp)
title('FIR-Hamming window Lowpass Filter')


hn=eqfir(33,[0 .2;.25 .35;.4 .5],[0 1 0],[1 1 1]);
[hm,fr]=frmag(hn,256);
figure;
plot2d(fr,hm)
title('FIR-Multiband Filter response')